/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.AbstractInput;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class CheckboxInput
extends AbstractInput {
    private Button button;
    private boolean value;
    private boolean enabled = true;
    private boolean focus = false;

    public CheckboxInput(boolean value) {
        this.value = value;
        this.hasChanged();
    }

    @Override
    public Control getControl() {
        String name;
        if (this.button != null) {
            return this.button;
        }
        this.button = GUI.getStyleFactory().createCheckbox(this.getParent());
        this.button.setSelection(this.value);
        Object tooltip = this.getData("datakey.tooltip");
        if (tooltip != null) {
            this.button.setToolTipText(tooltip.toString());
        }
        if ((name = this.getName()) != null) {
            this.button.setText(name);
        }
        if (this.focus) {
            this.button.setFocus();
        }
        this.button.setEnabled(this.enabled);
        if (this.isMandatory() && Application.getConfig().getMandatoryLabel()) {
            this.button.setForeground(Color.ERROR.getSWTColor());
        }
        return this.button;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (name != null && this.button != null && !this.button.isDisposed()) {
            this.button.setText(name);
        }
    }

    @Override
    public Object getValue() {
        if (this.button != null && !this.button.isDisposed()) {
            this.value = this.button.getSelection();
        }
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof Boolean)) {
            return;
        }
        this.value = (Boolean)value;
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setSelection(this.value);
            this.button.redraw();
        }
    }

    @Override
    public void focus() {
        this.focus = true;
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setFocus();
        }
    }

    @Override
    public void disable() {
        this.setEnabled(false);
    }

    @Override
    public void enable() {
        this.setEnabled(true);
    }

    @Override
    public boolean isEnabled() {
        if (this.button == null || this.button.isDisposed()) {
            return this.enabled;
        }
        return this.button.getEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setEnabled(enabled);
        }
    }

    @Override
    protected void addListener(Widget w, Listener l) {
        w.addListener(13, l);
    }

    @Override
    protected void update() throws OperationCanceledException {
    }
}

